<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ReceiptController;
use App\Http\Controllers\ReceiptDownloadController;
use App\Http\Controllers\ShareLinkController;
use App\Http\Controllers\BillingController;
use App\Http\Controllers\Admin\AdminDashboardController;
use App\Http\Controllers\Admin\AdminReceiptController;

Route::get('/', function () {
    return view('welcome');
});

// Billing is auth-only (NOT subscription-gated)
Route::middleware(['auth'])->group(function () {
    Route::get('/billing', [BillingController::class, 'index'])->name('billing');
    Route::post('/billing/checkout', [BillingController::class, 'checkout'])->name('billing.checkout');
    Route::post('/billing/portal', [BillingController::class, 'portal'])->name('billing.portal');
});

// App features are subscription-gated
Route::middleware(['auth', 'subscribed'])->group(function () {
    Route::get('/dashboard', [ReceiptController::class, 'index'])->name('dashboard');

    Route::resource('receipts', ReceiptController::class)->only(['index', 'create', 'store', 'show', 'destroy']);

    Route::get('receipts/{receipt}/download', ReceiptDownloadController::class)
        ->name('receipts.download');

    Route::post('receipts/{receipt}/share', [ShareLinkController::class, 'store'])
        ->name('receipts.share');

    Route::prefix('admin')->middleware('admin')->group(function () {
        Route::get('/', [AdminDashboardController::class, 'index'])->name('admin.dashboard');
        Route::get('/receipts', [AdminReceiptController::class, 'index'])->name('admin.receipts');
    });
});

Route::get('/p/{token}', [ShareLinkController::class, 'show'])->name('proof.show');

// Stripe webhook (Cashier)
Route::post('/stripe/webhook', '\\Laravel\\Cashier\\Http\\Controllers\\WebhookController@handleWebhook');
