<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\ReceiptApiController;
use App\Http\Controllers\Api\ShareLinkApiController;

Route::prefix('v1')->group(function () {
    Route::post('/auth/login', [AuthController::class, 'login']);
    Route::post('/auth/logout', [AuthController::class, 'logout'])->middleware('auth:sanctum');

    Route::get('/proof/{token}', [ShareLinkApiController::class, 'show']);

    Route::middleware(['auth:sanctum', 'subscribed'])->group(function () {
        Route::get('/receipts', [ReceiptApiController::class, 'index']);
        Route::post('/receipts', [ReceiptApiController::class, 'store']);
        Route::get('/receipts/{receipt}', [ReceiptApiController::class, 'show']);
        Route::get('/receipts/{receipt}/download', [ReceiptApiController::class, 'download']);
        Route::post('/receipts/{receipt}/share', [ShareLinkApiController::class, 'store']);
    });
});
