@extends('layouts.app')

@section('content')
<div class="max-w-3xl mx-auto">
  <div class="bg-white rounded-2xl shadow p-6">
    <h1 class="text-2xl font-semibold">ReceiptBasket</h1>
    <p class="mt-2 text-gray-600">Upload receipts. Search them. Share proof links. Simple.</p>

    @auth
      <div class="mt-4 flex flex-col sm:flex-row gap-3">
        <a href="{{ route('dashboard') }}" class="px-4 py-2 rounded-lg bg-black text-white text-center">Go to Dashboard</a>
        <a href="{{ route('billing') }}" class="px-4 py-2 rounded-lg border text-center">Billing</a>
      </div>
    @else
      <div class="mt-4 flex flex-col sm:flex-row gap-3">
        <a href="/login" class="px-4 py-2 rounded-lg bg-black text-white text-center">Login</a>
        <a href="/register" class="px-4 py-2 rounded-lg border text-center">Create account</a>
      </div>
    @endauth
  </div>
</div>
@endsection
