@extends('layouts.app')

@section('content')
<div class="flex items-start justify-between gap-4">
  <div>
    <h2 class="text-xl font-semibold">Receipt</h2>
    <div class="text-sm text-gray-600">{{ $receipt->original_filename }}</div>
  </div>
  <a class="rounded-xl px-4 py-2 border" href="{{ route('receipts.index') }}">Back</a>
</div>

<div class="mt-4 bg-white rounded-2xl shadow p-6 space-y-2">
  <div><span class="text-gray-500">Merchant:</span> {{ $receipt->merchant ?? '—' }}</div>
  <div><span class="text-gray-500">Total:</span> {{ $receipt->total_amount !== null ? number_format((float)$receipt->total_amount, 2) . ' ' . $receipt->currency : '—' }}</div>
  <div><span class="text-gray-500">Date:</span> {{ $receipt->purchased_at?->format('Y-m-d H:i') ?? '—' }}</div>
  @if($receipt->notes)
    <div class="pt-2">
      <div class="text-gray-500">Notes:</div>
      <div class="whitespace-pre-wrap">{{ $receipt->notes }}</div>
    </div>
  @endif

  <div class="pt-4 flex flex-col sm:flex-row gap-2">
    <a class="w-full sm:w-auto inline-flex justify-center rounded-xl px-4 py-2 bg-black text-white" href="{{ route('receipts.download', $receipt) }}">Download</a>

    <form class="w-full sm:w-auto" method="POST" action="{{ route('receipts.share', $receipt) }}">
      @csrf
      <button class="w-full inline-flex justify-center rounded-xl px-4 py-2 border" type="submit">Create proof link</button>
    </form>

    <form class="w-full sm:w-auto" method="POST" action="{{ route('receipts.destroy', $receipt) }}" onsubmit="return confirm('Delete this receipt?')">
      @csrf
      @method('DELETE')
      <button class="w-full inline-flex justify-center rounded-xl px-4 py-2 border border-red-300 text-red-700" type="submit">Delete</button>
    </form>
  </div>
</div>
@endsection
