@extends('layouts.app')

@section('content')
<div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3">
  <h2 class="text-xl font-semibold">Your Receipts</h2>
  <a href="{{ route('receipts.create') }}" class="inline-flex justify-center rounded-xl px-4 py-2 bg-black text-white">Upload receipt</a>
</div>

<form class="mt-4" method="GET" action="{{ route('receipts.index') }}">
  <div class="flex gap-2">
    <input name="q" value="{{ request('q') }}" placeholder="Search merchant, filename, notes" class="w-full rounded-xl border px-3 py-2" />
    <button class="rounded-xl px-4 py-2 border" type="submit">Search</button>
  </div>
</form>

<div class="mt-4 bg-white rounded-2xl shadow overflow-hidden">
  <div class="divide-y">
    @forelse($receipts as $r)
      <div class="p-4 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-2">
        <div>
          <div class="font-medium">{{ $r->merchant ?? $r->original_filename }}</div>
          <div class="text-sm text-gray-600">
            {{ $r->purchased_at?->format('Y-m-d') ?? '—' }} ·
            {{ $r->total_amount !== null ? number_format((float)$r->total_amount, 2) . ' ' . $r->currency : '—' }}
          </div>
        </div>
        <a href="{{ route('receipts.show', $r) }}" class="text-sm rounded-xl px-3 py-2 border inline-flex justify-center">Open</a>
      </div>
    @empty
      <div class="p-6 text-gray-600">No receipts yet. Upload your first one.</div>
    @endforelse
  </div>
</div>

<div class="mt-4">{{ $receipts->links() }}</div>
@endsection
