@extends('layouts.app')

@section('content')
<h2 class="text-xl font-semibold">Upload Receipt</h2>

<form class="mt-4 bg-white rounded-2xl shadow p-6 space-y-4" method="POST" action="{{ route('receipts.store') }}" enctype="multipart/form-data">
  @csrf

  <div>
    <label class="text-sm font-medium">File (PDF or image)</label>
    <input class="mt-1 block w-full" type="file" name="file" required />
    @error('file')<div class="text-sm text-red-600 mt-1">{{ $message }}</div>@enderror
  </div>

  <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
    <div>
      <label class="text-sm font-medium">Merchant</label>
      <input class="mt-1 w-full rounded-xl border px-3 py-2" name="merchant" value="{{ old('merchant') }}" />
      @error('merchant')<div class="text-sm text-red-600 mt-1">{{ $message }}</div>@enderror
    </div>
    <div>
      <label class="text-sm font-medium">Purchased at</label>
      <input class="mt-1 w-full rounded-xl border px-3 py-2" type="datetime-local" name="purchased_at" value="{{ old('purchased_at') }}" />
      @error('purchased_at')<div class="text-sm text-red-600 mt-1">{{ $message }}</div>@enderror
    </div>
    <div>
      <label class="text-sm font-medium">Total amount</label>
      <input class="mt-1 w-full rounded-xl border px-3 py-2" name="total_amount" value="{{ old('total_amount') }}" />
      @error('total_amount')<div class="text-sm text-red-600 mt-1">{{ $message }}</div>@enderror
    </div>
    <div>
      <label class="text-sm font-medium">Currency</label>
      <input class="mt-1 w-full rounded-xl border px-3 py-2" name="currency" value="{{ old('currency','CAD') }}" />
      @error('currency')<div class="text-sm text-red-600 mt-1">{{ $message }}</div>@enderror
    </div>
  </div>

  <div>
    <label class="text-sm font-medium">Notes</label>
    <textarea class="mt-1 w-full rounded-xl border px-3 py-2" name="notes" rows="3">{{ old('notes') }}</textarea>
    @error('notes')<div class="text-sm text-red-600 mt-1">{{ $message }}</div>@enderror
  </div>

  <button class="w-full rounded-xl px-4 py-2 bg-black text-white" type="submit">Upload</button>
</form>
@endsection
