@extends('layouts.app')

@section('content')
<div class="max-w-3xl mx-auto">
  <div class="bg-white rounded-2xl shadow p-6">
    <h2 class="text-xl font-semibold">Proof of Purchase</h2>
    <div class="mt-2 text-sm text-gray-600">
      Views: {{ $link->view_count }}
      @if($link->max_views)
        / {{ $link->max_views }}
      @endif
      @if($link->expires_at)
        · Expires: {{ $link->expires_at->format('Y-m-d H:i') }}
      @endif
    </div>

    <div class="mt-4 space-y-2">
      <div><span class="text-gray-500">Merchant:</span> {{ $receipt->merchant ?? '—' }}</div>
      <div><span class="text-gray-500">Total:</span> {{ $receipt->total_amount !== null ? number_format((float)$receipt->total_amount, 2) . ' ' . $receipt->currency : '—' }}</div>
      <div><span class="text-gray-500">Date:</span> {{ $receipt->purchased_at?->format('Y-m-d H:i') ?? '—' }}</div>
      @if($receipt->notes)
        <div class="pt-2">
          <div class="text-gray-500">Notes:</div>
          <div class="whitespace-pre-wrap">{{ $receipt->notes }}</div>
        </div>
      @endif
    </div>

    <div class="mt-5 text-sm text-gray-500">
      This page is shareable. It intentionally shows only safe metadata.
    </div>
  </div>
</div>
@endsection
