<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>{{ config('app.name', 'ReceiptBasket') }}</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 text-gray-900">
  <nav class="bg-white border-b">
    <div class="max-w-6xl mx-auto px-4 py-3 flex items-center justify-between">
      <a href="/" class="font-semibold">ReceiptBasket</a>
      <div class="flex items-center gap-3">
        @auth
          <a class="text-sm" href="{{ route('dashboard') }}">Dashboard</a>
          <a class="text-sm" href="{{ route('receipts.create') }}">Upload</a>
          <a class="text-sm" href="{{ route('billing') }}">Billing</a>
          @if(auth()->user()->is_admin)
            <a class="text-sm" href="{{ route('admin.dashboard') }}">Admin</a>
          @endif
          <form method="POST" action="/logout">
            @csrf
            <button class="text-sm px-3 py-1 rounded-lg border" type="submit">Logout</button>
          </form>
        @else
          <a class="text-sm" href="/login">Login</a>
          <a class="text-sm px-3 py-1 rounded-lg bg-black text-white" href="/register">Register</a>
        @endauth
      </div>
    </div>
  </nav>

  <main class="max-w-6xl mx-auto px-4 py-6">
    @if(session('error'))
      <div class="mb-4 p-3 rounded-xl bg-red-50 border border-red-200 text-red-800">{{ session('error') }}</div>
    @endif
    @if(session('status'))
      <div class="mb-4 p-3 rounded-xl bg-green-50 border border-green-200 text-green-800">{{ session('status') }}</div>
    @endif
    @if(session('proof_url'))
      <div class="mb-4 p-3 rounded-xl bg-blue-50 border border-blue-200 text-blue-900">
        Proof link: <a class="underline" href="{{ session('proof_url') }}" target="_blank">{{ session('proof_url') }}</a>
      </div>
    @endif

    @yield('content')
  </main>
</body>
</html>
