@extends('layouts.app')

@section('content')
<div class="max-w-2xl mx-auto">
  <div class="bg-white rounded-2xl shadow p-6">
    <h2 class="text-xl font-semibold">Billing</h2>
    <p class="mt-2 text-gray-600">Subscription required to access the app.</p>

    @if($user && method_exists($user, 'subscribed') && $user->subscribed('default'))
      <div class="mt-4 p-3 rounded-xl bg-green-50 border border-green-200 text-green-800">You are subscribed.</div>
      <form class="mt-4" method="POST" action="{{ route('billing.portal') }}">
        @csrf
        <button class="w-full rounded-xl px-4 py-2 border" type="submit">Open Stripe Billing Portal</button>
      </form>
    @else
      <form class="mt-4" method="POST" action="{{ route('billing.checkout') }}">
        @csrf
        <button class="w-full rounded-xl px-4 py-2 bg-black text-white" type="submit">Subscribe (Monthly)</button>
      </form>
      <div class="mt-3 text-sm text-gray-500">You will be redirected to Stripe Checkout.</div>
    @endif
  </div>
</div>
@endsection
