@extends('layouts.app')

@section('content')
<div class="space-y-4">
  <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3">
    <h1 class="text-2xl font-semibold">All Receipts</h1>

    <form method="GET" class="flex gap-2">
      <input name="q" value="{{ request('q') }}" placeholder="Search merchant / filename / notes" class="w-full md:w-80 border rounded-lg px-3 py-2" />
      <button class="px-4 py-2 rounded-lg bg-black text-white">Search</button>
    </form>
  </div>

  <div class="rounded-xl border bg-white overflow-hidden">
    <div class="overflow-x-auto">
      <table class="min-w-full text-sm">
        <thead class="text-left bg-gray-50">
          <tr>
            <th class="p-3">Date</th>
            <th class="p-3">User</th>
            <th class="p-3">Merchant</th>
            <th class="p-3">Amount</th>
            <th class="p-3">File</th>
          </tr>
        </thead>
        <tbody>
          @foreach($receipts as $r)
            <tr class="border-t">
              <td class="p-3">{{ $r->created_at->format('Y-m-d H:i') }}</td>
              <td class="p-3">{{ $r->user?->email }}</td>
              <td class="p-3">{{ $r->merchant ?? '—' }}</td>
              <td class="p-3">{{ $r->total_amount ? number_format($r->total_amount,2) . ' ' . $r->currency : '—' }}</td>
              <td class="p-3">{{ $r->original_filename }}</td>
            </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>

  <div>
    {{ $receipts->links() }}
  </div>
</div>
@endsection
