@extends('layouts.app')

@section('content')
<div class="space-y-6">
  <div class="flex items-center justify-between">
    <h1 class="text-2xl font-semibold">Admin Dashboard</h1>
    <a class="text-sm underline" href="{{ route('admin.receipts') }}">View all receipts</a>
  </div>

  <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
    <div class="p-4 rounded-xl border bg-white">
      <div class="text-sm text-gray-500">Users</div>
      <div class="text-3xl font-semibold">{{ $userCount }}</div>
    </div>
    <div class="p-4 rounded-xl border bg-white">
      <div class="text-sm text-gray-500">Receipts</div>
      <div class="text-3xl font-semibold">{{ $receiptCount }}</div>
    </div>
    <div class="p-4 rounded-xl border bg-white">
      <div class="text-sm text-gray-500">Latest</div>
      <div class="text-sm text-gray-700">Last 10 uploads</div>
    </div>
  </div>

  <div class="rounded-xl border bg-white overflow-hidden">
    <div class="p-4 border-b font-medium">Latest receipts</div>
    <div class="overflow-x-auto">
      <table class="min-w-full text-sm">
        <thead class="text-left bg-gray-50">
          <tr>
            <th class="p-3">Date</th>
            <th class="p-3">User</th>
            <th class="p-3">Merchant</th>
            <th class="p-3">File</th>
          </tr>
        </thead>
        <tbody>
          @foreach($latestReceipts as $r)
            <tr class="border-t">
              <td class="p-3">{{ $r->created_at->format('Y-m-d H:i') }}</td>
              <td class="p-3">{{ $r->user?->email }}</td>
              <td class="p-3">{{ $r->merchant ?? '—' }}</td>
              <td class="p-3">{{ $r->original_filename }}</td>
            </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>
</div>
@endsection
