<?php

namespace App\Policies;

use App\Models\Receipt;
use App\Models\User;

class ReceiptPolicy
{
    public function view(User $user, Receipt $receipt): bool
    {
        return (int)$receipt->user_id === (int)$user->id || (bool)$user->is_admin;
    }

    public function delete(User $user, Receipt $receipt): bool
    {
        return (int)$receipt->user_id === (int)$user->id || (bool)$user->is_admin;
    }
}
