<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class EnsureSubscribed
{
    public function handle(Request $r, Closure $next)
    {
        $user = $r->user();
        $subscribed = $user && method_exists($user, 'subscribed') && $user->subscribed('default');

        if (!$subscribed) {
            if ($r->expectsJson()) {
                return response()->json(['message' => 'Subscription required'], 402);
            }

            return redirect()->route('billing')->with('error', 'Subscription required.');
        }

        return $next($r);
    }
}
