<?php

namespace App\Http\Controllers;

use App\Models\Receipt;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ReceiptDownloadController extends Controller
{
    public function __invoke(Request $request, Receipt $receipt)
    {
        $this->authorize('view', $receipt);

        return Storage::disk('local')->download(
            $receipt->stored_path,
            $receipt->original_filename
        );
    }
}
