<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class BillingController extends Controller
{
    public function index(Request $request)
    {
        return view('billing.index', [
            'user' => $request->user(),
        ]);
    }

    public function checkout(Request $request)
    {
        $priceId = (string)env('RECEIPTBASKET_PRICE_MONTHLY');
        if ($priceId === '') {
            abort(500, 'Missing RECEIPTBASKET_PRICE_MONTHLY');
        }

        return $request->user()
            ->newSubscription('default', $priceId)
            ->checkout([
                'success_url' => route('dashboard'),
                'cancel_url' => route('billing'),
            ]);
    }

    public function portal(Request $request)
    {
        return $request->user()->redirectToBillingPortal(route('billing'));
    }
}
