<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Receipt;
use Illuminate\Http\Request;

class AdminReceiptController extends Controller
{
    public function index(Request $r)
    {
        $query = Receipt::query()->with('user')->latest();

        if ($s = trim((string)$r->get('q'))) {
            $query->where(function ($w) use ($s) {
                $w->where('merchant', 'like', "%{$s}%")
                    ->orWhere('original_filename', 'like', "%{$s}%")
                    ->orWhere('notes', 'like', "%{$s}%");
            });
        }

        return view('admin.receipts', [
            'receipts' => $query->paginate(50)->withQueryString(),
        ]);
    }
}
