<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Receipt;
use App\Models\User;

class AdminDashboardController extends Controller
{
    public function index()
    {
        return view('admin.dashboard', [
            'userCount' => User::count(),
            'receiptCount' => Receipt::count(),
            'latestReceipts' => Receipt::with('user')->latest()->take(10)->get(),
        ]);
    }
}
