# ReceiptBasket v1 (Laravel + Blade + Tailwind + MySQL) — App Code Pack

This ZIP is **NOT** a full Laravel framework bundle (no `/vendor`), because this environment doesn't include Composer.

You will deploy by:
1) Creating a fresh Laravel app on your cPanel host (Composer is usually available there).
2) Copying the files from this pack into that Laravel app (overwrite the same paths).
3) Running migrations + setting `.env`.

## 1) Create a fresh Laravel app on cPanel
In cPanel Terminal:

```bash
mkdir -p ~/apps/receiptbasket && cd ~/apps/receiptbasket
composer create-project laravel/laravel .
composer require laravel/breeze laravel/sanctum laravel/cashier
php artisan breeze:install blade
npm install && npm run build   # only for compiling Tailwind assets (optional if you use CDN)
```

> If you want **zero Node on server**, use Tailwind CDN for v1 (see below). The included Blade uses Tailwind classes either way.

## 2) Copy this pack into your Laravel app
Upload/extract this ZIP, then copy its folders into the Laravel project root:
- `app/`
- `routes/`
- `database/`
- `resources/`

## 3) Register middleware aliases
### Laravel 11+
Edit `bootstrap/app.php` and add aliases:

```php
->withMiddleware(function ($middleware) {
    $middleware->alias([
        'subscribed' => \App\Http\Middleware\EnsureSubscribed::class,
        'admin' => \App\Http\Middleware\EnsureAdmin::class,
    ]);
})
```

### Laravel 10 and earlier
Edit `app/Http/Kernel.php` and add:

```php
protected $routeMiddleware = [
  // ...
  'subscribed' => \App\Http\Middleware\EnsureSubscribed::class,
  'admin' => \App\Http\Middleware\EnsureAdmin::class,
];
```

## 4) Environment variables (.env)
Minimum:

```env
APP_NAME=ReceiptBasket
APP_ENV=production
APP_URL=https://app.yourdomain.com

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=receiptbasket
DB_USERNAME=receiptbasket_user
DB_PASSWORD=strong_password

# Stripe
STRIPE_KEY=pk_live_xxx
STRIPE_SECRET=sk_live_xxx
STRIPE_WEBHOOK_SECRET=whsec_xxx
RECEIPTBASKET_PRICE_MONTHLY=price_xxx
CASHIER_CURRENCY=cad
CASHIER_CURRENCY_LOCALE=en_CA
```

## 5) Migrate + storage
```bash
php artisan key:generate
php artisan migrate
php artisan storage:link
php artisan optimize
```

Receipts are stored **privately** under:
- `storage/app/private/receipts`

## 6) Stripe webhook
Set Stripe webhook URL:
- `https://app.yourdomain.com/stripe/webhook`

Recommended events:
- checkout.session.completed
- invoice.payment_succeeded
- invoice.payment_failed
- customer.subscription.updated
- customer.subscription.deleted

## 7) Point your domain to `/public`
In cPanel, set the subdomain document root to:
- `/home/USERNAME/apps/receiptbasket/public`

## 8) Admin user
Make a user admin in DB:
```sql
UPDATE users SET is_admin = 1 WHERE email='you@example.com' LIMIT 1;
```

---

# Tailwind without Node (optional)
If you refuse Node entirely on the server:
- Use Tailwind CDN in `resources/views/layouts/app.blade.php` (already included).
- You can still build locally later.

